import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Function to update odds based on performance weight and head-to-head weight  
def update_odds(match_id, performance_weight, h2h_weight, data, h2h_win_rates):  
    match = data.loc[match_id]  
    player_1 = match['Player_1']  
    player_2 = match['Player_2']  
  
    player_1_win_rate = player_stats.loc[player_stats['Opponent'] == player_1, 'Win Rate']  
    player_2_win_rate = player_stats.loc[player_stats['Opponent'] == player_2, 'Win Rate']  
  
    player_1_win_rate = player_1_win_rate.iloc[0] if not player_1_win_rate.empty else 0  
    player_2_win_rate = player_2_win_rate.iloc[0] if not player_2_win_rate.empty else 0  
  
    h2h_player_1_win_rate = h2h_win_rates.loc[h2h_win_rates['Opponent'] == player_2, 'Head-to-Head Win Rate']  
    h2h_player_2_win_rate = h2h_win_rates.loc[h2h_win_rates['Opponent'] == player_1, 'Head-to-Head Win Rate']  
  
    h2h_player_1_win_rate = h2h_player_1_win_rate.iloc[0] if not h2h_player_1_win_rate.empty else 0  
    h2h_player_2_win_rate = h2h_player_2_win_rate.iloc[0] if not h2h_player_2_win_rate.empty else 0  
  
    player_1_probability, player_2_probability = estimate_probability(player_1_win_rate, player_2_win_rate, h2h_player_1_win_rate, h2h_player_2_win_rate, performance_weight, h2h_weight)  
    max_odd_1 = data['Odd_1'].max()  
    max_odd_2 = data['Odd_2'].max()  
      
    if player_1_probability == 0:  
        updated_odd_1 = max_odd_1  
    else:  
        updated_odd_1 = 1 / player_1_probability  
      
    if player_2_probability == 0:  
        updated_odd_2 = max_odd_2  
    else:  
        updated_odd_2 = 1 / player_2_probability  
  
    return updated_odd_1, updated_odd_2  